using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Assert = NUnit.Framework.Assert;
#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7OruMessage_MshSegment : BaseTest
	{
		#region Variables & Setup


        static Messages_HL7OruMessage_MshSegment()
		{
            
		}

        //1 	1 	ST 	R  	Field Separator
        //2 	4 	ST 	R  	Encoding Characters
        //7 	26 	TS 	R  	Date/Time Of Message
        //9 	13 	CM 	R 	Message Type
        //10 	20 	ST 	R 	Message Control ID
        //11 	3 	PT 	R 	Processing ID
        //12 	60 	VID 	R 	Version ID

	    [SetUp]
	    public void SetUp()
	    {

	        

	    }

	    #endregion

		#region Constructors

		[Test]
		public void MshSegment_Valid_Pass()
		{

            string _MshSegment = "MSH|^~\\&|IM|589|VBECS|589|20080526135401-0500||ORU^R01|1048|P|2.4|6||AL|NE";
            char[] delimiters = HL7Utility.ParseGetMessageDelimiters(_MshSegment);

            List<string> errorList = new List<string>();

            HL7AIOruMessage.MshSegment mshSegment = new HL7AIOruMessage.MshSegment(_MshSegment, delimiters, ref errorList);

            Assert.IsTrue(errorList.Count == 0);

        }

		[Test]
		public void MissingControlSequence_Fail()
		{
            string _MshSegment = "MSH|^~\\&|IM|589|VBECS|589|20080526135401-0500||ORU^R01|1048|P|2.4|6||AL|NE";
            char[] delimiters = HL7Utility.ParseGetMessageDelimiters(_MshSegment);
            
            List<string> errorList = new List<string>();

            HL7AIOruMessage.MshSegment mshSegment = new HL7AIOruMessage.MshSegment(_MshSegment, delimiters, ref errorList);
			
            Assert.IsTrue(errorList.Count == 0);
		}

		#endregion

		#region Methods


		#endregion

		#region Properties


		#endregion
    [Test]
    public void get_FieldSeperatorTest()
    {
        // TODO: Implement unit test for get_FieldSeperatorTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_FieldSeperatorTest()
    {
        // TODO: Implement unit test for set_FieldSeperatorTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_ComponentSeparatorTest()
    {
        // TODO: Implement unit test for get_ComponentSeparatorTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ComponentSeparatorTest()
    {
        // TODO: Implement unit test for set_ComponentSeparatorTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_MSHFieldsTest()
    {
        // TODO: Implement unit test for get_MSHFieldsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_MSHFieldsTest()
    {
        // TODO: Implement unit test for set_MSHFieldsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_SendingApplicationTest()
    {
        // TODO: Implement unit test for get_SendingApplicationTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SendingApplicationTest()
    {
        // TODO: Implement unit test for set_SendingApplicationTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_SendingFacilityTest()
    {
        // TODO: Implement unit test for get_SendingFacilityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SendingFacilityTest()
    {
        // TODO: Implement unit test for set_SendingFacilityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_ReceivingApplicationTest()
    {
        // TODO: Implement unit test for get_ReceivingApplicationTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ReceivingApplicationTest()
    {
        // TODO: Implement unit test for set_ReceivingApplicationTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_ReceivingFacilityTest()
    {
        // TODO: Implement unit test for get_ReceivingFacilityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ReceivingFacilityTest()
    {
        // TODO: Implement unit test for set_ReceivingFacilityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_MessageDateTimeTest()
    {
        // TODO: Implement unit test for get_MessageDateTimeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_MessageDateTimeTest()
    {
        // TODO: Implement unit test for set_MessageDateTimeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_SecurityTest()
    {
        // TODO: Implement unit test for get_SecurityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SecurityTest()
    {
        // TODO: Implement unit test for set_SecurityTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_MessageTypeTest()
    {
        // TODO: Implement unit test for get_MessageTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_MessageTypeTest()
    {
        // TODO: Implement unit test for set_MessageTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_MessageControlIDTest()
    {
        // TODO: Implement unit test for get_MessageControlIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_MessageControlIDTest()
    {
        // TODO: Implement unit test for set_MessageControlIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_ProcessingIDTest()
    {
        // TODO: Implement unit test for get_ProcessingIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ProcessingIDTest()
    {
        // TODO: Implement unit test for set_ProcessingIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_VersionIDTest()
    {
        // TODO: Implement unit test for get_VersionIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_VersionIDTest()
    {
        // TODO: Implement unit test for set_VersionIDTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_SequenceNumberTest()
    {
        // TODO: Implement unit test for get_SequenceNumberTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_SequenceNumberTest()
    {
        // TODO: Implement unit test for set_SequenceNumberTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_ContinuationPointerTest()
    {
        // TODO: Implement unit test for get_ContinuationPointerTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ContinuationPointerTest()
    {
        // TODO: Implement unit test for set_ContinuationPointerTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_AcceptAcknowledgmentTypeTest()
    {
        // TODO: Implement unit test for get_AcceptAcknowledgmentTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_AcceptAcknowledgmentTypeTest()
    {
        // TODO: Implement unit test for set_AcceptAcknowledgmentTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_ApplicationAcknowledgmentTypeTest()
    {
        // TODO: Implement unit test for get_ApplicationAcknowledgmentTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void set_ApplicationAcknowledgmentTypeTest()
    {
        // TODO: Implement unit test for set_ApplicationAcknowledgmentTypeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void ToStringTest()
    {
        // TODO: Implement unit test for ToStringTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void EqualsTest()
    {
        // TODO: Implement unit test for EqualsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void GetHashCodeTest()
    {
        // TODO: Implement unit test for GetHashCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void GetTypeTest()
    {
        // TODO: Implement unit test for GetTypeTest
    }

	}
}
#endif